/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.DateFormatter;
import java.io.Serializable;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SRCEntry
implements PIDataBeanInterface {
    public static final String KEY_SRC_YEAR = "year";
    public static final String KEY_SRC_MONTH = "month";
    public static final String KEY_SRC_DAY = "day";
    public static final String KEY_SRC_HOUR = "hour";
    public static final String KEY_SRC_MINUTES = "minutes";
    public static final String KEY_SRC_SECONDS = "seconds";
    public static final String KEY_SRC_TIMESTAMP = "time_stamp";
    public static final String KEY_SRC_VERSION = "version";
    public static final String KEY_SRC_SEQUENCE = "refcode_num";
    public static final String KEY_SRC_WORD1 = "word2";
    public static final String KEY_SRC_WORD2 = "word3";
    public static final String KEY_SRC_WORD3 = "word4";
    public static final String KEY_SRC_WORD4 = "word5";
    public static final String KEY_SRC_WORD5 = "word6";
    public static final String KEY_SRC_WORD6 = "word7";
    public static final String KEY_SRC_WORD7 = "word8";
    public static final String KEY_SRC_WORD8 = "word9";
    public static final String KEY_SRC_DISPLAY = "refcode";
    public static final String KEY_SRC_FRU_CALL_OUT_LOC_CODES = "fru_call_out_loc_codes";
    public static final String KEY_SRC_LPAR_ID = "lpar_id";
    public static final String KEY_SRC_LPAR_NAME = "lpar_name";
    public static final String DELIM = "|";
    private static final int MAX_FRU_CALL_OUTS_DISPLAYED = 6;
    public static final String[] ALL_KEYS = new String[]{"version", "refcode_num", "time_stamp", "word2", "word3", "word4", "word5", "word6", "word7", "word8", "word9", "refcode", "fru_call_out_loc_codes", "lpar_id", "lpar_name"};
    public String m_srcVersion = "";
    public String m_srcSeqNum = "0";
    public String m_word1 = "";
    public String m_word2 = "";
    public String m_word3 = "";
    public String m_word4 = "";
    public String m_word5 = "";
    public String m_word6 = "";
    public String m_word7 = "";
    public String m_word8 = "";
    public String m_defaultDisplay = "";
    public int m_wordCount = 0;
    public String m_srcFlag = "";
    public boolean m_isSubSection = false;
    public String m_year = "";
    public String m_month = "";
    public String m_day = "";
    public String m_hour = "";
    public String m_minutes = "";
    public String m_seconds = "";
    public String m_lparID;
    public String m_lparName;
    public boolean m_blankSRC;
    public Vector m_fruCalloutStruct = new Vector();

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public SRCEntry(String string, String string2) {
        this(string, string2, 0);
    }

    public SRCEntry(String string, String string2, int n) {
        if (!"EMPTY".equals(string)) {
            this.m_blankSRC = false;
            this._parseSRCString(string, n);
            if (string2 != null) {
                this.m_isSubSection = true;
                this._parseSubSec(string2);
            }
        } else {
            this.m_blankSRC = true;
        }
    }

    public SRCEntry() {
        this.m_blankSRC = true;
    }

    public String getTimeStamp() {
        String string = "";
        try {
            DateFormatter dateFormatter = DateFormatter.getDefaultInstance();
            Date date = dateFormatter.getDateTime(Integer.parseInt(this.m_year), Integer.parseInt(this.m_month), Integer.parseInt(this.m_day), Integer.parseInt(this.m_hour), Integer.parseInt(this.m_minutes), Integer.parseInt(this.m_seconds));
            string = dateFormatter.formatDateTime(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getDefaultDisplay() {
        return this.m_defaultDisplay;
    }

    public Vector getFruCalloutStruct() {
        return this.m_fruCalloutStruct;
    }

    public String getSrcVersion() {
        return this.m_srcVersion;
    }

    public String getSrcSeqNum() {
        return this.m_srcSeqNum;
    }

    public String getWord1() {
        return this.m_word1;
    }

    public String getWord2() {
        return this.m_word2;
    }

    public String getWord3() {
        return this.m_word3;
    }

    public String getWord4() {
        return this.m_word4;
    }

    public String getWord5() {
        return this.m_word5;
    }

    public String getWord6() {
        return this.m_word6;
    }

    public String getWord7() {
        return this.m_word7;
    }

    public String getWord8() {
        return this.m_word8;
    }

    public String getYear() {
        return this.m_year;
    }

    public String getMonth() {
        return this.m_month;
    }

    public String getDay() {
        return this.m_day;
    }

    public String getHour() {
        return this.m_hour;
    }

    public String getMinutes() {
        return this.m_minutes;
    }

    public String getSeconds() {
        return this.m_seconds;
    }

    public boolean isSubSection() {
        return this.m_isSubSection;
    }

    public String getLparID() {
        return this.m_lparID;
    }

    public String getLparName() {
        return this.m_lparName;
    }

    public boolean isBlankSRC() {
        return this.m_blankSRC;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (KEY_SRC_VERSION.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_srcVersion, bl);
                continue;
            }
            if (KEY_SRC_SEQUENCE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_srcSeqNum, bl);
                continue;
            }
            if (KEY_SRC_WORD1.equals(string2)) {
                if (bl && this.m_word1.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word1, bl);
                continue;
            }
            if (KEY_SRC_WORD2.equals(string2)) {
                if (bl && this.m_word2.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word2, bl);
                continue;
            }
            if (KEY_SRC_WORD3.equals(string2)) {
                if (bl && this.m_word3.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word3, bl);
                continue;
            }
            if (KEY_SRC_WORD4.equals(string2)) {
                if (bl && this.m_word4.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word4, bl);
                continue;
            }
            if (KEY_SRC_WORD5.equals(string2)) {
                if (bl && this.m_word5.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word5, bl);
                continue;
            }
            if (KEY_SRC_WORD6.equals(string2)) {
                if (bl && this.m_word6.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word6, bl);
                continue;
            }
            if (KEY_SRC_WORD7.equals(string2)) {
                if (bl && this.m_word7.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word7, bl);
                continue;
            }
            if (KEY_SRC_WORD8.equals(string2)) {
                if (bl && this.m_word8.length() <= 0) continue;
                CSVRecord.append(cSVRecord, string2, this.m_word8, bl);
                continue;
            }
            if (KEY_SRC_DISPLAY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_defaultDisplay, bl);
                continue;
            }
            if (KEY_SRC_FRU_CALL_OUT_LOC_CODES.equals(string2)) {
                if (this.m_fruCalloutStruct.size() == 0) {
                    if (bl) continue;
                    CSVRecord.append(cSVRecord, string2, (String)null, bl);
                    continue;
                }
                CSVRecord cSVRecord2 = new CSVRecord(true, ",");
                for (int j = 0; j < this.m_fruCalloutStruct.size(); ++j) {
                    FRUCalloutStructure fRUCalloutStructure = (FRUCalloutStructure)this.m_fruCalloutStruct.get(j);
                    cSVRecord2.add(fRUCalloutStructure.getLocCode());
                }
                CSVRecord.append(cSVRecord, string2, cSVRecord2.toString(), bl);
                continue;
            }
            if (KEY_SRC_TIMESTAMP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getTimeStamp(), bl);
                continue;
            }
            if (KEY_SRC_LPAR_ID.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_lparID, bl);
                continue;
            }
            if (!KEY_SRC_LPAR_NAME.equals(string2)) continue;
            CSVRecord.append(cSVRecord, string2, this.m_lparName, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    private void _parseSRCString(String string, int n) {
        String[] stringArray = new String[8];
        int n2 = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
            try {
                int n3;
                this.m_srcSeqNum = stringTokenizer.nextToken();
                if (n > 0) {
                    n3 = Integer.parseInt(this.m_srcSeqNum);
                    this.m_srcSeqNum = String.valueOf(n3 += n);
                }
                this.m_year = stringTokenizer.nextToken();
                this.m_month = stringTokenizer.nextToken();
                this.m_day = stringTokenizer.nextToken();
                this.m_hour = stringTokenizer.nextToken();
                this.m_minutes = stringTokenizer.nextToken();
                this.m_seconds = stringTokenizer.nextToken();
                this.m_srcVersion = stringTokenizer.nextToken();
                this.m_srcFlag = stringTokenizer.nextToken();
                this.m_wordCount = Integer.parseInt(stringTokenizer.nextToken());
                if (this.m_wordCount > 0) {
                    n2 = this.m_wordCount - 1;
                }
                stringTokenizer.nextToken();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = stringTokenizer.nextToken();
                }
                for (n3 = n2; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = "";
                }
                this.m_word1 = stringArray[0];
                this.m_word2 = stringArray[1];
                this.m_word3 = stringArray[2];
                this.m_word4 = stringArray[3];
                this.m_word5 = stringArray[4];
                this.m_word6 = stringArray[5];
                this.m_word7 = stringArray[6];
                this.m_word8 = stringArray[7];
                if (stringTokenizer.hasMoreTokens()) {
                    this.m_defaultDisplay = stringTokenizer.nextToken();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
        }
    }

    private void _parseSubSec(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            for (int i = 0; i < 6 && (n = stringBuffer.indexOf("FRU_CALL_OUT_START", n)) != -1; ++i) {
                FRUCalloutStructure fRUCalloutStructure = new FRUCalloutStructure();
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.substring(n += "FRU_CALL_OUT_START".length() + 1), DELIM, true);
                try {
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    fRUCalloutStructure.m_locCode = stringTokenizer.nextToken();
                    if (DELIM.equals(fRUCalloutStructure.m_locCode)) {
                        fRUCalloutStructure.m_locCode = "";
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                }
                this.m_fruCalloutStruct.add(fRUCalloutStructure);
            }
        }
    }

    public static class FRUCalloutStructure
    implements Serializable {
        public String m_locCode = "";

        public String getLocCode() {
            return this.m_locCode;
        }
    }
}

